<?php

use App\Models\User;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Widget\AbstractWidget;
use Illuminate\Support\Collection;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Blog\Models\Tag;
use Botble\Widget\Forms\WidgetForm;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class FeaturedAuthorsWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('FeaturedAuthors'),
            'description' => __('Widget description'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        $form = WidgetForm::createFromArray($this->getConfig())
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
                    ->toArray()
            );

        $authors = User::query()
            ->select(['id', DB::raw("CONCAT(first_name, ' ', last_name) AS name")])
            ->pluck('name', 'id')
            ->all();

        $data = $form->getModel();
        $authorIds = Arr::get($data, 'author_ids');

        $params = [
            'author_ids',
            SelectField::class,
            SelectFieldOption::make()
                ->label(__('Choose authors'))
                ->choices($authors)
                ->selected($authorIds)
                ->searchable()
                ->multiple()
                ->toArray(),
        ];

        $form->add(...$params);

        return $form;
    }

    protected function data(): array|Collection
    {
        $config = $this->getConfig();
        $title = Arr::get($config, 'title');
        $authorIds = Arr::get($config, 'author_ids');

        if (empty($authorIds)) {
            return [];
        }

        $authors = User::query()
            ->whereIn('id', $authorIds)
            ->get()
            ->keyBy('id')
            ->all();

        if (!$authors) {
            return [];
        }

        return compact('title', 'authors');
    }
}
