@php
    $searchStyle = [];
    $searchBgColor = theme_option('home_search_background_color');
    $searchTextColor = theme_option('home_search_text_color');
    $searchHoverColor = theme_option('home_search_hover_color');

    if ($searchBgColor !== 'transparent') {
        $searchStyle["--search-background-color: $searchBgColor"] = $searchBgColor;
    }

    if ($searchTextColor !== 'transparent') {
        $searchStyle["--search-text-color: $searchTextColor"] = $searchTextColor;
    }

    if ($searchHoverColor !== 'transparent') {
        $searchStyle["--search-hover-background-color: $searchHoverColor"] = $searchHoverColor;
    }
@endphp

@if (is_plugin_active('blog'))
    <div class="search-icon header__search header-search-btn widget-search-action-button">
        <a
            aria-label="Search button"
            href="#"
        >
            <x-core::icon name="ti ti-search" />
        </a>
    </div>

    <div class="header-search-form-wrapper">
        <div class="tx-search-close tx-close"><x-core::icon name="ti ti-x" /></div>
        <div class="header-search-container">
            <form
                action="{{ route('public.search') }}"
                role="search"
                class="search-form"
                data-ajax-url="{{ route('public.search') }}"
            >
                <input
                    type="search"
                    class="search-field"
                    placeholder="{{ __('Search...') }}"
                    value=""
                    name="q"
                />
                <button
                    type="submit"
                    class="search-submit"
                >
                    <x-core::icon name="ti ti-search" />
                </button>

                <div
                    class="search-results"
                    @style($searchStyle)
                >
                    <div class="no-data">
                        <h5>{{ __('No results found') }}</h5>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="body-overlay"></div>
@endif
