@if ($event)
    @php
        $backgroundColor = Arr::get($config, 'background_color');
        $backgroundImage = Arr::get($config, 'background_image');
        $backgroundImage = $backgroundImage ? RvMedia::getImageUrl($backgroundImage) : null;
    @endphp

    <div
        class="widget-upcoming-event cta1-section-area"
        @style([
            "--background-color: $backgroundColor" => $backgroundColor,
            "--background-image: url($backgroundImage)" => $backgroundImage,
        ])
    >
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="cta1-main-boxarea">
                        <div class="timer-btn-area">
                            <div
                                class="timer"
                                data-target="{{ $event->started_at }}"
                            >
                                <div class="time-box">
                                    <span class="time-value days"></span>
                                    <br />
                                </div>
                                <div class="space14"></div>
                                <div class="time-box">
                                    <span class="time-value hours"></span>
                                    <br />
                                </div>
                                <div class="space14"></div>
                                <div class="time-box">
                                    <span class="time-value minutes"></span>
                                    <br />
                                </div>
                                <div class="space14"></div>
                                <div
                                    class="time-box"
                                    style="margin: 0 26px 0 0"
                                >
                                    <span class="time-value seconds"></span>
                                    <br />
                                </div>
                            </div>
                            <div class="btn-area1">
                                <a
                                    href="{{ $event->url }}"
                                    class="vl-btn1"
                                >{!! BaseHelper::clean(__(Arr::get($config, 'button_label') ?: __('Buy Ticket'))) !!}</a>
                            </div>
                        </div>
                        <ul>
                            <li>
                                <a href="{{ $event->url }}">
                                    <x-core::icon name="ti ti-calendar" />
                                    {{ $event->event_time }}
                                </a>
                            </li>
                            <li class="m-0">
                                <a href="{{ $event->url }}">
                                    <x-core::icon name="ti ti-map-pin" />
                                    {{ $event->address }}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
