<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class EXHIBZ_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	 */

	public static function get_icons() {

		$icons = array(
                  'icon icon-building' => 'icon icon-building',
                  'icon icon-cycle' => 'icon icon-cycle',
                  'icon icon-food' => 'icon icon-food',
                  'icon icon-fun' => 'icon icon-fun',
                  'icon icon-hotel' => 'icon icon-hotel',
                  'icon icon-marketing' => 'icon icon-marketing',
                  'icon icon-Monetizing' => 'icon icon-Monetizing',
                  'icon icon-netwrorking' => 'icon icon-netwrorking',
                  'icon icon-people' => 'icon icon-people',
                  'icon icon-planning' => 'icon icon-planning',
                  'icon icon-pricing-1Asset-1' => 'icon icon-pricing-1Asset-1',
                  'icon icon-pricing-2Asset-2' => 'icon icon-pricing-2Asset-2',
                  'icon icon-pricing-3Asset-3' => 'icon icon-pricing-3Asset-3',
                  'icon icon-ring-1Asset-1' => 'icon icon-ring-1Asset-1',
                  'icon icon-ring-2Asset-1' => 'icon icon-ring-2Asset-1',
                  'icon icon-ring-3Asset-2' => 'icon icon-ring-3Asset-2',
                  'icon icon-ring-4Asset-3' => 'icon icon-ring-4Asset-3',
                  'icon icon-speaker' => 'icon icon-speaker',
                  'icon icon-home' => 'icon icon-home',
                  'icon icon-apartment' => 'icon icon-apartment',
                  'icon icon-pencil' => 'icon icon-pencil',
                  'icon icon-magic-wand' => 'icon icon-magic-wand',
                  'icon icon-drop' => 'icon icon-drop',
                  'icon icon-lighter' => 'icon icon-lighter',
                  'icon icon-poop' => 'icon icon-poop',
                  'icon icon-sun' => 'icon icon-sun',
                  'icon icon-moon' => 'icon icon-moon',
                  'icon icon-cloud' => 'icon icon-cloud',
                  'icon icon-cloud-upload' => 'icon icon-cloud-upload',
                  'icon icon-cloud-download' => 'icon icon-cloud-download',
                  'icon icon-cloud-sync' => 'icon icon-cloud-sync',
                  'icon icon-cloud-check' => 'icon icon-cloud-check',
                  'icon icon-database' => 'icon icon-database',
                  'icon icon-lock' => 'icon icon-lock',
                  'icon icon-cog' => 'icon icon-cog',
                  'icon icon-trash' => 'icon icon-trash',
                  'icon icon-dice' => 'icon icon-dice',
                  'icon icon-heart' => 'icon icon-heart',
                  'icon icon-star' => 'icon icon-star',
                  'icon icon-star-half' => 'icon icon-star-half',
                  'icon icon-star-empty' => 'icon icon-star-empty',
                  'icon icon-flag' => 'icon icon-flag',
                  'icon icon-envelope' => 'icon icon-envelope',
                  'icon icon-paperclip' => 'icon icon-paperclip',
                  'icon icon-inbox' => 'icon icon-inbox',
                  'icon icon-eye' => 'icon icon-eye',
                  'icon icon-printer' => 'icon icon-printer',
                  'icon icon-file-empty' => 'icon icon-file-empty',
                  'icon icon-file-add' => 'icon icon-file-add',
                  'icon icon-enter' => 'icon icon-enter',
                  'icon icon-exit' => 'icon icon-exit',
                  'icon icon-graduation-hat' => 'icon icon-graduation-hat',
                  'icon icon-license' => 'icon icon-license',
                  'icon icon-music-note' => 'icon icon-music-note',
                  'icon icon-film-play' => 'icon icon-film-play',
                  'icon icon-camera-video' => 'icon icon-camera-video',
                  'icon icon-camera' => 'icon icon-camera',
                  'icon icon-picture' => 'icon icon-picture',
                  'icon icon-book' => 'icon icon-book',
                  'icon icon-bookmark' => 'icon icon-bookmark',
                  'icon icon-user' => 'icon icon-user',
                  'icon icon-users' => 'icon icon-users',
                  'icon icon-shirt' => 'icon icon-shirt',
                  'icon icon-store' => 'icon icon-store',
                  'icon icon-cart' => 'icon icon-cart',
                  'icon icon-tag' => 'icon icon-tag',
                  'icon icon-phone-handset' => 'icon icon-phone-handset',
                  'icon icon-phone' => 'icon icon-phone',
                  'icon icon-pushpin' => 'icon icon-pushpin',
                  'icon icon-map-marker' => 'icon icon-map-marker',
                  'icon icon-map' => 'icon icon-map',
                  'icon icon-location' => 'icon icon-location',
                  'icon icon-calendar-full' => 'icon icon-calendar-full',
                  'icon icon-keyboard' => 'icon icon-keyboard',
                  'icon icon-spell-check' => 'icon icon-spell-check',
                  'icon icon-screen' => 'icon icon-screen',
                  'icon icon-smartphone' => 'icon icon-smartphone',
                  'icon icon-tablet' => 'icon icon-tablet',
                  'icon icon-laptop' => 'icon icon-laptop',
                  'icon icon-laptop-phone' => 'icon icon-laptop-phone',
                  'icon icon-power-switch' => 'icon icon-power-switch',
                  'icon icon-bubble' => 'icon icon-bubble',
                  'icon icon-heart-pulse' => 'icon icon-heart-pulse',
                  'icon icon-construction' => 'icon icon-construction',
                  'icon icon-pie-chart' => 'icon icon-pie-chart',
                  'icon icon-chart-bars' => 'icon icon-chart-bars',
                  'icon icon-gift' => 'icon icon-gift',
                  'icon icon-diamond' => 'icon icon-diamond',
                  'icon icon-dinner' => 'icon icon-dinner',
                  'icon icon-coffee-cup' => 'icon icon-coffee-cup',
                  'icon icon-leaf' => 'icon icon-leaf',
                  'icon icon-paw' => 'icon icon-paw',
                  'icon icon-rocket' => 'icon icon-rocket',
                  'icon icon-briefcase' => 'icon icon-briefcase',
                  'icon icon-bus' => 'icon icon-bus',
                  'icon icon-car' => 'icon icon-car',
                  'icon icon-train' => 'icon icon-train',
                  'icon icon-bicycle' => 'icon icon-bicycle',
                  'icon icon-wheelchair' => 'icon icon-wheelchair',
                  'icon icon-select' => 'icon icon-select',
                  'icon icon-earth' => 'icon icon-earth',
                  'icon icon-smile' => 'icon icon-smile',
                  'icon icon-sad' => 'icon icon-sad',
                  'icon icon-neutral' => 'icon icon-neutral',
                  'icon icon-mustache' => 'icon icon-mustache',
                  'icon icon-alarm' => 'icon icon-alarm',
                  'icon icon-bullhorn' => 'icon icon-bullhorn',
                  'icon icon-volume-high' => 'icon icon-volume-high',
                  'icon icon-volume-medium' => 'icon icon-volume-medium',
                  'icon icon-volume-low' => 'icon icon-volume-low',
                  'icon icon-volume' => 'icon icon-volume',
                  'icon icon-mic' => 'icon icon-mic',
                  'icon icon-hourglass' => 'icon icon-hourglass',
                  'icon icon-undo' => 'icon icon-undo',
                  'icon icon-redo' => 'icon icon-redo',
                  'icon icon-sync' => 'icon icon-sync',
                  'icon icon-history' => 'icon icon-history',
                  'icon icon-clock' => 'icon icon-clock',
                  'icon icon-download' => 'icon icon-download',
                  'icon icon-upload' => 'icon icon-upload',
                  'icon icon-enter-down' => 'icon icon-enter-down',
                  'icon icon-exit-up' => 'icon icon-exit-up',
                  'icon icon-bug' => 'icon icon-bug',
                  'icon icon-code' => 'icon icon-code',
                  'icon icon-link' => 'icon icon-link',
                  'icon icon-unlink' => 'icon icon-unlink',
                  'icon icon-thumbs-up' => 'icon icon-thumbs-up',
                  'icon icon-thumbs-down' => 'icon icon-thumbs-down',
                  'icon icon-magnifier' => 'icon icon-magnifier',
                  'icon icon-cross' => 'icon icon-cross',
                  'icon icon-menu' => 'icon icon-menu',
                  'icon icon-list' => 'icon icon-list',
                  'icon icon-chevron-up' => 'icon icon-chevron-up',
                  'icon icon-chevron-down' => 'icon icon-chevron-down',
                  'icon icon-chevron-left' => 'icon icon-chevron-left',
                  'icon icon-chevron-right' => 'icon icon-chevron-right',
                  'icon icon-arrow-up' => 'icon icon-arrow-up',
                  'icon icon-arrow-down' => 'icon icon-arrow-down',
                  'icon icon-arrow-left' => 'icon icon-arrow-left',
                  'icon icon-arrow-right' => 'icon icon-arrow-right',
                  'icon icon-move' => 'icon icon-move',
                  'icon icon-warning' => 'icon icon-warning',
                  'icon icon-question-circle' => 'icon icon-question-circle',
                  'icon icon-menu-circle' => 'icon icon-menu-circle',
                  'icon icon-checkmark-circle' => 'icon icon-checkmark-circle',
                  'icon icon-cross-circle' => 'icon icon-cross-circle',
                  'icon icon-plus-circle' => 'icon icon-plus-circle',
                  'icon icon-circle-minus' => 'icon icon-circle-minus',
                  'icon icon-arrow-up-circle' => 'icon icon-arrow-up-circle',
                  'icon icon-arrow-down-circle' => 'icon icon-arrow-down-circle',
                  'icon icon-arrow-left-circle' => 'icon icon-arrow-left-circle',
                  'icon icon-arrow-right-circle' => 'icon icon-arrow-right-circle',
                  'icon icon-chevron-up-circle' => 'icon icon-chevron-up-circle',
                  'icon icon-chevron-down-circle' => 'icon icon-chevron-down-circle',
                  'icon icon-chevron-left-circle' => 'icon icon-chevron-left-circle',
                  'icon icon-chevron-right-circle' => 'icon icon-chevron-right-circle',
                  'icon icon-crop' => 'icon icon-crop',
                  'icon icon-frame-expand' => 'icon icon-frame-expand',
                  'icon icon-frame-contract' => 'icon icon-frame-contract',
                  'icon icon-layers' => 'icon icon-layers',
                  'icon icon-funnel' => 'icon icon-funnel',
                  'icon icon-text-format' => 'icon icon-text-format',
                  'icon icon-text-size' => 'icon icon-text-size',
                  'icon icon-bold' => 'icon icon-bold',
                  'icon icon-italic' => 'icon icon-italic',
                  'icon icon-underline' => 'icon icon-underline',
                  'icon icon-strikethrough' => 'icon icon-strikethrough',
                  'icon icon-highlight' => 'icon icon-highlight',
                  'icon icon-text-align-left' => 'icon icon-text-align-left',
                  'icon icon-text-align-center' => 'icon icon-text-align-center',
                  'icon icon-text-align-right' => 'icon icon-text-align-right',
                  'icon icon-text-align-justify' => 'icon icon-text-align-justify',
                  'icon icon-line-spacing' => 'icon icon-line-spacing',
                  'icon icon-indent-increase' => 'icon icon-indent-increase',
                  'icon icon-indent-decrease' => 'icon icon-indent-decrease',
                  'icon icon-page-break' => 'icon icon-page-break',
                  'icon icon-hand' => 'icon icon-hand',
                  'icon icon-pointer-up' => 'icon icon-pointer-up',
                  'icon icon-pointer-right' => 'icon icon-pointer-right',
                  'icon icon-pointer-down' => 'icon icon-pointer-down',
                  'icon icon-pointer-left' => 'icon icon-pointer-left',
                  'icon icon-vplay' => 'icon icon-vplay',
                  'icon icon-newsletter' => 'icon icon-newsletter',
                  'icon icon-coins-2' => 'icon icon-coins-2',
                  'icon icon-commerce-2' => 'icon icon-commerce-2',
                  'icon icon-monitor' => 'icon icon-monitor',
                  'icon icon-facebook' => 'icon icon-facebook',
                  'icon icon-business' => 'icon icon-business',
                  'icon icon-graphic-2' => 'icon icon-graphic-2',
                  'icon icon-commerce-1' => 'icon icon-commerce-1',
                  'icon icon-like' => 'icon icon-like',
                  'icon icon-home1' => 'icon icon-home1',
                  'icon icon-phone-call' => 'icon icon-phone-call',
                  'icon icon-contact' => 'icon icon-contact',
                  'icon icon-comments' => 'icon icon-comments',
                  'icon icon-cloud-computing' => 'icon icon-cloud-computing',
                  'icon icon-care' => 'icon icon-care',
                  'icon icon-coin' => 'icon icon-coin',
                  'icon icon-donation' => 'icon icon-donation',
                  'icon icon-donation_2' => 'icon icon-donation_2',
                  'icon icon-heart1' => 'icon icon-heart1',
                  'icon icon-dove' => 'icon icon-dove',
                  'icon icon-drop1' => 'icon icon-drop1',
                  'icon icon-first-aid-kit' => 'icon icon-first-aid-kit',
                  'icon icon-groceries' => 'icon icon-groceries',
                  'icon icon-heartbeat' => 'icon icon-heartbeat',
                  'icon icon-left-arrow' => 'icon icon-left-arrow',
                  'icon icon-newspaper' => 'icon icon-newspaper',
                  'icon icon-open-book' => 'icon icon-open-book',
                  'icon icon-down-arrow' => 'icon icon-down-arrow',
                  'icon icon-planet-earth' => 'icon icon-planet-earth',
                  'icon icon-plus-button' => 'icon icon-plus-button',
                  'icon icon-poor-water-supply' => 'icon icon-poor-water-supply',
                  'icon icon-tap-water' => 'icon icon-tap-water',
                  'icon icon-support' => 'icon icon-support',
                  'icon icon-sweater' => 'icon icon-sweater',
                  'icon icon-doctor' => 'icon icon-doctor',
                  'icon icon-team' => 'icon icon-team',
                  'icon icon-group' => 'icon icon-group',
                  'icon icon-family' => 'icon icon-family',
                  'icon icon-children' => 'icon icon-children',
                  'icon icon-team_2' => 'icon icon-team_2',
                  'icon icon-telemarketer' => 'icon icon-telemarketer',
                  'icon icon-water' => 'icon icon-water',
                  'icon icon-twitter' => 'icon icon-twitter',
                  'icon icon-twitter1' => 'icon icon-twitter1',
                  'icon icon-linkedin' => 'icon icon-linkedin',
                  'icon icon-youtube' => 'icon icon-youtube',
                  'icon icon-dribbble' => 'icon icon-dribbble',
                  'icon icon-pinterest' => 'icon icon-pinterest',
                  'icon icon-vimeo' => 'icon icon-vimeo',
                  'icon icon-soundcloud' => 'icon icon-soundcloud',
                  'icon icon-youtube-v' => 'icon icon-youtube-v',
                  'icon icon-behance' => 'icon icon-behance',
                  'icon icon-google-plus' => 'icon icon-google-plus',
                  'icon icon-instagram' => 'icon icon-instagram',
                  'icon icon-hammer' => 'icon icon-hammer',
                  'icon icon-justice-1' => 'icon icon-justice-1',
                  'icon icon-double-left-chevron' => 'icon icon-double-left-chevron',
                  'icon icon-double-angle-pointing-to-right' => 'icon icon-double-angle-pointing-to-right',
                  'icon icon-arrow-point-to-down' => 'icon icon-arrow-point-to-down',
                  'icon icon-play-button' => 'icon icon-play-button',
                  'icon icon-minus' => 'icon icon-minus',
                  'icon icon-plus' => 'icon icon-plus',
                  'icon icon-tick' => 'icon icon-tick',
                  'icon icon-download-arrow' => 'icon icon-download-arrow',
                  'icon icon-edit' => 'icon icon-edit',
                  'icon icon-reply' => 'icon icon-reply',
                  'icon icon-cogwheel-outline' => 'icon icon-cogwheel-outline',
                  'icon icon-symbol' => 'icon icon-symbol',
                  'icon icon-calendar' => 'icon icon-calendar',
                  'icon icon-shopping-cart' => 'icon icon-shopping-cart',
                  'icon icon-shopping-basket' => 'icon icon-shopping-basket',
                  'icon icon-users1' => 'icon icon-users1',
                  'icon icon-man' => 'icon icon-man',
                  'icon icon-support1' => 'icon icon-support1',
                  'icon icon-favorites' => 'icon icon-favorites',
                  'icon icon-calendar1' => 'icon icon-calendar1',
                  'icon icon-paper-plane' => 'icon icon-paper-plane',
                  'icon icon-placeholder' => 'icon icon-placeholder',
                  'icon icon-phone-call1' => 'icon icon-phone-call1',
                  'icon icon-contact1' => 'icon icon-contact1',
                  'icon icon-email' => 'icon icon-email',
                  'icon icon-internet' => 'icon icon-internet',
                  'icon icon-quote' => 'icon icon-quote',
                  'icon icon-line' => 'icon icon-line',
                  'icon icon-money-3' => 'icon icon-money-3',
                  'icon icon-commerce' => 'icon icon-commerce',
                  'icon icon-tools' => 'icon icon-tools',
                  'icon icon-pie-chart1' => 'icon icon-pie-chart1',
                  'icon icon-diamond1' => 'icon icon-diamond1',
                  'icon icon-agenda' => 'icon icon-agenda',
                  'icon icon-like1' => 'icon icon-like1',
                  'icon icon-justice' => 'icon icon-justice',
                  'icon icon-technology' => 'icon icon-technology',
                  'icon icon-coins-1' => 'icon icon-coins-1',
                  'icon icon-left-arrow1' => 'icon icon-left-arrow1',
                  'icon icon-bank' => 'icon icon-bank',
                  'icon icon-calculator' => 'icon icon-calculator',
                  'icon icon-chart2' => 'icon icon-chart2',
                  'icon icon-map-marker1' => 'icon icon-map-marker1',
                  'icon icon-mutual-fund' => 'icon icon-mutual-fund',
                  'icon icon-phone1' => 'icon icon-phone1',
                  'icon icon-pie-chart2' => 'icon icon-pie-chart2',
                  'icon icon-play' => 'icon icon-play',
                  'icon icon-savings' => 'icon icon-savings',
                  'icon icon-search' => 'icon icon-search',
                  'icon icon-tag1' => 'icon icon-tag1',
                  'icon icon-tags' => 'icon icon-tags',
                  'icon icon-loan' => 'icon icon-loan',
                  'icon icon-checked' => 'icon icon-checked',
                  'icon icon-clock1' => 'icon icon-clock1',
                  'icon icon-comment' => 'icon icon-comment',
                  'icon icon-comments1' => 'icon icon-comments1',
                  'icon icon-consult' => 'icon icon-consult',
                  'icon icon-consut2' => 'icon icon-consut2',
                  'icon icon-envelope1' => 'icon icon-envelope1',
                  'icon icon-folder' => 'icon icon-folder',
                  'icon icon-invest' => 'icon icon-invest',
                  'icon icon-right-arrow2' => 'icon icon-right-arrow2',
                  'icon icon-quote1' => 'icon icon-quote1',
                  'icon icon-deal' => 'icon icon-deal',
                  'icon icon-left-arrow2' => 'icon icon-left-arrow2',
                  'icon icon-team1' => 'icon icon-team1',
                  'icon icon-tshirt' => 'icon icon-tshirt',
                  'icon icon-cancel' => 'icon icon-cancel',
                  'icon icon-drink' => 'icon icon-drink',
                  'icon icon-home2' => 'icon icon-home2',
                  'icon icon-music' => 'icon icon-music',
                  'icon icon-rich' => 'icon icon-rich',
                  'icon icon-brush' => 'icon icon-brush',
                  'icon icon-opposite-way' => 'icon icon-opposite-way',
                  'icon icon-cloud-computing1' => 'icon icon-cloud-computing1',
                  'icon icon-technology-1' => 'icon icon-technology-1',
                  'icon icon-rotate' => 'icon icon-rotate',
                  'icon icon-medical' => 'icon icon-medical',
                  'icon icon-flash-1' => 'icon icon-flash-1',
                  'icon icon-flash' => 'icon icon-flash',
                  'icon icon-down-arrow1' => 'icon icon-down-arrow1',
                  'icon icon-hours-support' => 'icon icon-hours-support',
                  'icon icon-bag' => 'icon icon-bag',
                  'icon icon-photo-camera' => 'icon icon-photo-camera',
                  'icon icon-search-minus' => 'icon icon-search-minus',
                  'icon icon-search1' => 'icon icon-search1',
                  'icon icon-down-arrow2' => 'icon icon-down-arrow2',
                  'icon icon-up-arrow' => 'icon icon-up-arrow',
                  'icon icon-right-arrow' => 'icon icon-right-arrow',
                  'icon icon-left-arrows' => 'icon icon-left-arrows',
                  'icon icon-school' => 'icon icon-school',
                  'icon icon-settings' => 'icon icon-settings',
                  'icon icon-smartphone1' => 'icon icon-smartphone1',
                  'icon icon-technology-11' => 'icon icon-technology-11',
                  'icon icon-tool' => 'icon icon-tool',
                  'icon icon-business1' => 'icon icon-business1',
                  'icon icon-van-1' => 'icon icon-van-1',
                  'icon icon-van' => 'icon icon-van',
                  'icon icon-vegetables' => 'icon icon-vegetables',
                  'icon icon-women' => 'icon icon-women',
                  'icon icon-vintage' => 'icon icon-vintage',
                  'icon icon-up-arrow1' => 'icon icon-up-arrow1',
                  'icon icon-arrows' => 'icon icon-arrows',
                  'icon icon-team2' => 'icon icon-team2',
                  'icon icon-team-1' => 'icon icon-team-1',
                  'icon icon-medal' => 'icon icon-medal',
                  'icon icon-uturn' => 'icon icon-uturn',
                  'icon icon-apple-1' => 'icon icon-apple-1',
                  'icon icon-apple' => 'icon icon-apple',
                  'icon icon-light-bulb' => 'icon icon-light-bulb',
                  'icon icon-light-bulb-1' => 'icon icon-light-bulb-1',
                  'icon icon-cogwheel' => 'icon icon-cogwheel',
                  'icon icon-watch' => 'icon icon-watch',
                  'icon icon-star1' => 'icon icon-star1',
                  'icon icon-star-1' => 'icon icon-star-1',
                  'icon icon-favorite' => 'icon icon-favorite',
                  'icon icon-medical1' => 'icon icon-medical1',
                  'icon icon-eye1' => 'icon icon-eye1',
                  'icon icon-full-screen' => 'icon icon-full-screen',
                  'icon icon-shuffle-arrow' => 'icon icon-shuffle-arrow',
                  'icon icon-online-shopping-cart' => 'icon icon-online-shopping-cart',
                  'icon icon-shopping-cart1' => 'icon icon-shopping-cart1',
                  'icon icon-heart-shape-outline' => 'icon icon-heart-shape-outline'
		);

		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">

				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'exhibz' ); ?>">

					<option value=""><?php esc_html_e( 'Select Icon', 'exhibz' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}

}
