<?php

namespace Elementor;

use \Etn\Utils\Helper;

if (!defined('ABSPATH')) exit;


class Exhibz_Event_Ticket_Widget extends Widget_Base
{


    public $base;

    public function get_name()
    {
        return 'exhibz-event-ticket';
    }

    public function get_title()
    {
        return esc_html__('Exhibz Event Variation Ticket', 'exhibz');
    }

    public function get_icon()
    {
        return 'eicon-slider-3d';
    }

    public function get_categories()
    {
        return ['exhibz-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Pricing settings', 'exhibz'),
            ]
        );

        $this->add_control(
            "event_id",
            [
                "label"     => esc_html__("Select Event", "exhibz"),
                "type"      => Controls_Manager::SELECT2,
                "multiple"  => false,
                "options"   => Helper::get_events(),
            ]
        );

        $this->add_control(
            "show_title",
            [
                "label" => esc_html__("Show Title", "exhibz"),
                "type"  => Controls_Manager::SWITCHER,
                "label_on"  => esc_html__("Show", "exhibz"),
                "label_on"  => esc_html__("Hide", "exhibz"),
                "default"   => "yes"
            ]
        );
        $this->end_controls_section();

        // Style tab
        $this->start_controls_section(
            'section_ticket_style',
            [
                'label'     => esc_html__('Ticket style', 'exhibz'),
                'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_variation_color',
            [
                'label'         => esc_html__('Ticket Variation Color', 'exhibz'),
                'type'          => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-title' => 'color: {{VALUE}} !important;'
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ticket_variation_typography',
                'selector' => '{{WRAPPER}} .exhibz-ticket-widget .ant-card-body .etn-ticket-title',
            ]
        );
        $this->add_control(
            'title_pricing_color',
            [
                'label'         => esc_html__('Pricing Label Color', 'exhibz'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-price-label' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-quantity-label' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-subtotal-label' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .ant-typography.etn-purchase-ticket-total-text span:first-child' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .ant-typography.etn-purchase-ticket-total-label span:first-child' => 'color: {{VALUE}} !important;',

                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ticket_title_typography',
                'selector' => '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-price-label, {{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-quantity-label, {{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-subtotal-label, {{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-purchase-ticket-total-text-span, {{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-purchase-ticket-total-label-text-span',
            ]
        );

        $this->add_control(
            'pricing_color',
            [
                'label'         => esc_html__('Pricing Color', 'exhibz'),
                'type'         => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-container .etn-ticket-price' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}   .exhibz-ticket-widget .ant-card-body .etn-ticket-subtotal' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}   .exhibz-ticket-widget .ant-card-body .ant-typography.etn-purchase-ticket-total-text span:last-child' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}}   .exhibz-ticket-widget .ant-card-body .ant-typography.etn-purchase-ticket-total-label span:last-child' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'Button_background',
            [
                'label'         => esc_html__('Button Background Color', 'exhibz'),
                'type'          => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .ant-btn-primary' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'ticket_background',
            [
                'label'         => esc_html__('Ticket Background Color', 'exhibz'),
                'type'          => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-quantity' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}}  .exhibz-ticket-widget .ant-card-body .etn-ticket-quantity .ant-input-number' => 'background-color: {{VALUE}} !important;'
                ],
            ]
        );
    } //Register control end

    protected function render()
    {
        $settings              = $this->get_settings();
        $single_event_id       = !empty($settings['event_id']) ? $settings['event_id'] : 0;

?>
        <div class="exhibz-ticket-widget">
            <?php if (!empty($settings["show_title"])) : ?>
                <h3 class="etn-event-form-widget-title">
                    <?php echo esc_html(get_the_title($single_event_id)); ?>
                </h3>
            <?php endif; ?>
            <?php
            if (class_exists('Wpeventin')) {
                echo do_shortcode("[event_variation_ticket_form id='$single_event_id' show_title='no']");
            }
            ?>

        </div>



<?php
    }
    protected function content_template() {}
}
