<?php
$category_limit = $exhibz_event_category_settings['category-options']['category_limit'];
$categories_id  = $exhibz_event_category_settings['category-options']['categories_id'];
$post_sort_by   = $exhibz_event_category_settings['category-options']['post_sort_by'];
$hide_empty     = $exhibz_event_category_settings['hide_empty'] == 'yes' ? '1' : '0';
$taxonomy       = 'etn_category';


$args_cat = array(
    'taxonomy'   => $taxonomy,
    'number'     => $category_limit,
    'hide_empty' => $hide_empty,
    'orderby'    => 'post_date',
    'order'      => $post_sort_by,
);

// If $categories_id is provided, filter them based on arguments
if (!empty($categories_id)) {
    $cats = get_terms(array_merge($args_cat, ['include' => $categories_id]));
} else {
    $cats = get_categories($args_cat);
}



?>
    <div class="ts-event-category">
		<?php foreach($cats as $value) {
			$term = get_term($value, $taxonomy);

			if(class_exists('CSF')) {
				$category_tax = get_term_meta($term->term_id, 'exhibz-etn-category', true);
				$img_url      = !empty($category_tax['event_category_featured_img']['url']) ? $category_tax['event_category_featured_img']['url'] : '';
				$term_link    = get_term_link($term->slug, $taxonomy);

				?>
                <div class="event-cat-item">
					<?php if($img_url != ''): ?>
                        <div class="cat-bg" style="background-image: url('<?php echo esc_url($img_url) ?>');">
                            <a class="cat-link" href="<?php echo esc_url($term_link); ?>"></a>
                        </div>
					<?php endif; ?>

                    <div class="cat-content">

                        <h3 class="ts-title"><a
                                    href="<?php echo esc_url($term_link); ?>"><?php echo esc_html($term->name); ?></a>
                        </h3>
                        <p class="cat-count">
							<?php printf(_nx('%s Event', '%s Events', $term->count, 'Events', 'exhibz'), number_format_i18n($term->count));
							?>
                        </p>
                    </div>
                </div>
				<?php
			}
		} ?>
    </div>
<?php
